<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';

echo "<h1>🔍 بررسی آخرین سفارش</h1>";
echo "<style>
body{font-family:Tahoma;padding:20px;direction:rtl;line-height:2;background:#f5f5f5;} 
.success{color:green;font-weight:bold;} 
.error{color:red;font-weight:bold;} 
.info{color:blue;font-weight:bold;} 
.warning{color:orange;font-weight:bold;}
pre{background:#fff;padding:15px;border-radius:8px;direction:ltr;overflow-x:auto;border:1px solid #ddd;font-size:12px;}
.box{background:white;padding:20px;margin:20px 0;border-radius:10px;box-shadow:0 2px 10px rgba(0,0,0,0.1);}
table{width:100%;border-collapse:collapse;margin:15px 0;}
table th{background:#667eea;color:white;padding:12px;text-align:right;}
table td{padding:10px;border:1px solid #ddd;}
table tr:nth-child(even){background:#f9f9f9;}
</style>";

$conn = getDBConnection();

// Get last 5 orders
$stmt = $conn->prepare("SELECT * FROM orders ORDER BY created_at DESC LIMIT 5");
$stmt->execute();
$result = $stmt->get_result();
$orders = [];
while ($row = $result->fetch_assoc()) {
    $orders[] = $row;
}
$stmt->close();
$conn->close();

echo "<div class='box'>";
echo "<h2>📊 آخرین سفارشات</h2>";

if (empty($orders)) {
    echo "<p class='error'>هیچ سفارشی وجود ندارد</p>";
} else {
    echo "<table>";
    echo "<tr>";
    echo "<th>ID</th>";
    echo "<th>وضعیت</th>";
    echo "<th>بسته</th>";
    echo "<th>قیمت (تومان)</th>";
    echo "<th>ICCID</th>";
    echo "<th>QR Code</th>";
    echo "<th>Activation Code</th>";
    echo "<th>تاریخ</th>";
    echo "</tr>";
    
    foreach ($orders as $order) {
        $statusColor = '';
        switch ($order['status']) {
            case 'paid':
                $statusColor = 'style="background:#d1fae5;color:#065f46;"';
                break;
            case 'pending':
                $statusColor = 'style="background:#fef3c7;color:#92400e;"';
                break;
            case 'failed':
            case 'cancelled':
                $statusColor = 'style="background:#fee;color:#c00;"';
                break;
        }
        
        echo "<tr>";
        echo "<td><strong>#{$order['id']}</strong></td>";
        echo "<td $statusColor><strong>{$order['status']}</strong></td>";
        echo "<td>" . htmlspecialchars($order['package_name']) . "</td>";
        echo "<td>" . number_format($order['price_irr']) . "</td>";
        echo "<td>" . ($order['iccid'] ? '<span class="success">✅ ' . substr($order['iccid'], 0, 15) . '...</span>' : '<span class="error">❌ ندارد</span>') . "</td>";
        echo "<td>" . ($order['qr_code'] ? '<span class="success">✅ دارد</span>' : '<span class="error">❌ ندارد</span>') . "</td>";
        echo "<td>" . ($order['activation_code'] ? '<span class="success">✅ دارد</span>' : '<span class="error">❌ ندارد</span>') . "</td>";
        echo "<td>" . date('Y-m-d H:i', strtotime($order['created_at'])) . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
}

echo "</div>";

// Show detailed info for last paid order
$lastPaidOrder = null;
foreach ($orders as $order) {
    if ($order['status'] === 'paid') {
        $lastPaidOrder = $order;
        break;
    }
}

if ($lastPaidOrder) {
    echo "<div class='box'>";
    echo "<h2>🔍 جزئیات آخرین سفارش موفق (#{$lastPaidOrder['id']})</h2>";
    
    echo "<table>";
    echo "<tr><th>فیلد</th><th>مقدار</th></tr>";
    
    foreach ($lastPaidOrder as $key => $value) {
        if (in_array($key, ['qr_code', 'activation_code']) && strlen($value) > 100) {
            $value = substr($value, 0, 100) . '...';
        }
        
        $highlight = '';
        if (in_array($key, ['iccid', 'qr_code', 'activation_code', 'esim_tran_no'])) {
            if (empty($value)) {
                $highlight = 'style="background:#fee;color:#c00;"';
            } else {
                $highlight = 'style="background:#d1fae5;color:#065f46;"';
            }
        }
        
        echo "<tr $highlight>";
        echo "<td><strong>$key</strong></td>";
        echo "<td>" . htmlspecialchars($value ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    // Check if eSIM data is missing
    if (empty($lastPaidOrder['iccid']) || empty($lastPaidOrder['qr_code'])) {
        echo "<div style='background:#fee;border:2px solid #fcc;padding:20px;border-radius:10px;margin-top:20px;'>";
        echo "<h3 class='error'>❌ مشکل: اطلاعات eSIM ناقص است!</h3>";
        echo "<p><strong>دلیل احتمالی:</strong></p>";
        echo "<ul>";
        echo "<li>API eSIM فراخوانی نشده</li>";
        echo "<li>خطا در ساخت eSIM از API</li>";
        echo "<li>مشکل در callback</li>";
        echo "</ul>";
        
        echo "<p><strong>راه حل:</strong></p>";
        echo "<form method='POST' style='margin-top:15px;'>";
        echo "<input type='hidden' name='order_id' value='{$lastPaidOrder['id']}'>";
        echo "<button type='submit' name='create_esim' style='background:#10b981;color:white;padding:15px 30px;border:none;border-radius:8px;cursor:pointer;font-weight:bold;font-size:16px;'>";
        echo "🔄 ساخت eSIM برای این سفارش";
        echo "</button>";
        echo "</form>";
        echo "</div>";
    } else {
        echo "<div style='background:#d1fae5;border:2px solid #10b981;padding:20px;border-radius:10px;margin-top:20px;'>";
        echo "<h3 class='success'>✅ اطلاعات eSIM کامل است</h3>";
        echo "<p>ICCID، QR Code و Activation Code موجود است.</p>";
        echo "</div>";
    }
    
    echo "</div>";
}

// Handle manual eSIM creation
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_esim'])) {
    $orderId = intval($_POST['order_id']);
    
    echo "<div class='box'>";
    echo "<h2>🔄 در حال ساخت eSIM...</h2>";
    
    require_once __DIR__ . '/api/esim-api.php';
    
    $conn = getDBConnection();
    $stmt = $conn->prepare("SELECT * FROM orders WHERE id = ?");
    $stmt->bind_param("i", $orderId);
    $stmt->execute();
    $result = $stmt->get_result();
    $order = $result->fetch_assoc();
    $stmt->close();
    $conn->close();
    
    if ($order && $order['status'] === 'paid') {
        try {
            $api = new eSIMAPI();
            
            echo "<p class='info'>📦 بسته: {$order['package_code']}</p>";
            echo "<p class='info'>💰 قیمت: " . $order['price_usd'] . " USD</p>";
            
            // Convert price to cents
            $priceInCents = round($order['price_usd'] * 100);
            echo "<p class='info'>💵 قیمت (سنت): $priceInCents</p>";
            
            echo "<p class='info'>🔄 در حال ارسال درخواست به API...</p>";
            
            $esimResult = $api->createESIMOrder($order['package_code'], 1, $priceInCents);
            
            echo "<h3>📄 پاسخ API:</h3>";
            echo "<pre>" . json_encode($esimResult, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
            
            if ($esimResult && isset($esimResult['success']) && $esimResult['success'] === true) {
                $orderNo = $esimResult['obj']['orderNo'] ?? null;
                
                if ($orderNo) {
                    echo "<p class='success'>✅ سفارش eSIM ساخته شد! Order No: $orderNo</p>";
                    echo "<p class='info'>⏳ صبر 3 ثانیه برای تخصیص eSIM...</p>";
                    
                    sleep(3);
                    
                    echo "<p class='info'>🔍 در حال دریافت جزئیات eSIM...</p>";
                    
                    $queryResult = $api->queryESIMByOrderNo($orderNo);
                    
                    echo "<h3>📄 پاسخ Query:</h3>";
                    echo "<pre>" . json_encode($queryResult, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
                    
                    if ($queryResult && isset($queryResult['success']) && $queryResult['success'] === true) {
                        $esimList = $queryResult['obj']['esimList'] ?? [];
                        
                        if (!empty($esimList)) {
                            $esim = $esimList[0];
                            
                            $esimData = [
                                'esim_id' => $esim['esimTranNo'] ?? '',
                                'iccid' => $esim['iccid'] ?? '',
                                'qr_code' => $esim['qrCodeUrl'] ?? '',
                                'activation_code' => $esim['ac'] ?? ''
                            ];
                            
                            echo "<p class='success'>✅ اطلاعات eSIM دریافت شد:</p>";
                            echo "<ul>";
                            echo "<li><strong>ICCID:</strong> {$esimData['iccid']}</li>";
                            echo "<li><strong>esimTranNo:</strong> {$esimData['esim_id']}</li>";
                            echo "<li><strong>QR Code:</strong> " . (empty($esimData['qr_code']) ? '❌' : '✅') . "</li>";
                            echo "<li><strong>Activation Code:</strong> " . (empty($esimData['activation_code']) ? '❌' : '✅') . "</li>";
                            echo "</ul>";
                            
                            // Update database
                            $conn = getDBConnection();
                            $stmt = $conn->prepare("UPDATE orders SET iccid = ?, esim_tran_no = ?, qr_code = ?, activation_code = ? WHERE id = ?");
                            $stmt->bind_param("ssssi", 
                                $esimData['iccid'],
                                $esimData['esim_id'],
                                $esimData['qr_code'],
                                $esimData['activation_code'],
                                $orderId
                            );
                            
                            if ($stmt->execute()) {
                                echo "<p class='success'>✅ دیتابیس به‌روز شد!</p>";
                                echo "<p><a href='/esim-details.php?id=$orderId' style='background:#667eea;color:white;padding:15px 30px;border-radius:8px;text-decoration:none;display:inline-block;margin-top:20px;font-weight:bold;'>مشاهده eSIM</a></p>";
                            } else {
                                echo "<p class='error'>❌ خطا در به‌روزرسانی دیتابیس: " . $stmt->error . "</p>";
                            }
                            
                            $stmt->close();
                            $conn->close();
                        } else {
                            echo "<p class='error'>❌ لیست eSIM خالی است</p>";
                        }
                    } else {
                        $errorMsg = $queryResult['errorMsg'] ?? 'نامشخص';
                        echo "<p class='error'>❌ خطا در Query: $errorMsg</p>";
                    }
                } else {
                    echo "<p class='error'>❌ OrderNo در پاسخ API یافت نشد</p>";
                }
            } else {
                $errorCode = $esimResult['errorCode'] ?? 'نامشخص';
                $errorMsg = $esimResult['errorMsg'] ?? 'نامشخص';
                echo "<p class='error'>❌ خطا در ساخت eSIM: $errorCode - $errorMsg</p>";
            }
        } catch (Exception $e) {
            echo "<p class='error'>❌ Exception: " . $e->getMessage() . "</p>";
        }
    } else {
        echo "<p class='error'>❌ سفارش یافت نشد یا وضعیت آن 'paid' نیست</p>";
    }
    
    echo "</div>";
    
    echo "<script>setTimeout(function(){ window.location.reload(); }, 3000);</script>";
}

echo "<hr>";
echo "<p style='text-align:center;'><a href='/dashboard.php' style='background:#667eea;color:white;padding:15px 30px;border-radius:8px;text-decoration:none;display:inline-block;font-weight:bold;'>بازگشت به داشبورد</a></p>";
?>

